const mergedTypes = [
  {
    "ParamIdString": "235",
    "Component": "Vehicle",
    "Comment": "P235\r\n\r\n",
    "ElementName": "Manufacturer",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ManufacturerType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleBaseType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "252",
    "Component": "Vehicle",
    "Comment": "P252\r\n\r\n",
    "ElementName": "ManufacturerAddress",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ManufacturerAddressType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ManufacturerAddress",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerAddressType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleBaseType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ManufacturerAddress",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerAddressType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "236",
    "Component": "Vehicle",
    "Comment": "P236\r\n\r\n",
    "ElementName": "Model",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ModelType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleBaseType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "238",
    "Component": "Vehicle",
    "Comment": "P238\r\n\r\n",
    "ElementName": "VIN",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:VINType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VIN",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VINType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleBaseType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VIN",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VINType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "239",
    "Component": "Vehicle",
    "Comment": "P239\r\n\r\n",
    "ElementName": "Date",
    "Type": "DateTime",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:DateTimeWithTimezone"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 2017-01-01T00:00:00Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Pattern: .+T.+Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleBaseType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "251",
    "Component": "Vehicle",
    "Comment": "P251 - enum\r\n\r\n",
    "ElementName": "LegislativeClass",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:LegislativeClassDeclarationType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- N2",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- N3",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "LegislativeClass",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "LegislativeClassDeclarationType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleBaseType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "LegislativeClass",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "LegislativeClassDeclarationType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "036",
    "Component": "Vehicle",
    "Comment": "P036 - enum\r\n\r\n",
    "ElementName": "VehicleCategory",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:VehicleCategoryDeclarationType",
      "v2.1:VehicleCategoryType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- Rigid Truck",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Tractor",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Rigid Lorry",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VehicleCategory",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleCategoryDeclarationType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleBaseType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VehicleCategory",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleCategoryDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleCategoryType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "037",
    "Component": "Vehicle",
    "Comment": "P037 - enum\r\n\r\n",
    "ElementName": "AxleConfiguration",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:VehicleAxleConfigurationDeclarationType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- 4x2",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- 6x2",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- 6x4",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- 8x4",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "AxleConfiguration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleAxleConfigurationDeclarationType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AxleConfiguration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleAxleConfigurationDeclarationType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "AxleConfiguration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleAxleConfigurationDeclarationType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "038",
    "Component": "Vehicle",
    "Comment": "P038 - [kg]\r\n\r\n",
    "ElementName": "CurbMassChassis",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:VehicleCurbMassChassisType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 500",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CurbMassChassis",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleCurbMassChassisType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CurbMassChassis",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleCurbMassChassisType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "041",
    "Component": "Vehicle",
    "Comment": "P041 - [kg]\r\n\r\n",
    "ElementName": "GrossVehicleMass",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:VehicleGrossVehicleMassType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 3500",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "GrossVehicleMass",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleGrossVehicleMassType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "GrossVehicleMass",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleGrossVehicleMassType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "198",
    "Component": "Vehicle",
    "Comment": "P198 - [1/min]\r\n\r\n",
    "ElementName": "IdlingSpeed",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineDeclaredSpeedType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "052",
    "Component": "Vehicle",
    "Comment": "P052 - enum\r\n\r\n",
    "ElementName": "RetarderType",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:RetarderTypeType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- None",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Losses included in Gearbox",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Engine Retarder",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Transmission Input Retarder",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Transmission Output Retarder",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RetarderType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "RetarderTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RetarderType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "RetarderTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "053",
    "Component": "Vehicle",
    "Comment": "P053 - [-]\r\n\r\n",
    "ElementName": "RetarderRatio",
    "Type": "Double3",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:RetarderRatioType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0.000",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "RetarderRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "RetarderRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "RetarderRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "RetarderRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "180",
    "Component": "Vehicle",
    "Comment": "P180 - enum\r\n\r\n",
    "ElementName": "AngledriveType",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AngledriveTypeType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- None",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Losses included in Gearbox",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Separate Angledrive",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AngledriveType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AngledriveType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "247",
    "Component": "Vehicle",
    "Comment": "P247 - enum\r\n\r\n",
    "ElementName": "PTOShaftsGearWheels",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:PTOShaftsGearWheelsType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- none",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- only the drive shaft of the PTO",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- drive shaft and/or up to 2 gear wheels",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- drive shaft and/or more than 2 gear wheels",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- only one engaged gearwheel above oil level",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PTO",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "PTOType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PTOShaftsGearWheels",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "PTOShaftsGearWheelsType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PTO",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "PTOType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PTOShaftsGearWheels",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "PTOShaftsGearWheelsType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "248",
    "Component": "Vehicle",
    "Comment": "P248 - enum\r\n\r\n",
    "ElementName": "PTOOtherElements",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:PTOOtherElementsType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- none",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- shift claw, synchronizer, sliding gearwheel",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- multi-disc clutch",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- multi-disc clutch, oil pump",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PTO",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "PTOType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PTOOtherElements",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "PTOOtherElementsType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PTO",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "PTOType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PTOOtherElements",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "PTOOtherElementsType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "269",
    "Component": "Vehicle",
    "Comment": "P269 - bool\r\n\r\n",
    "ElementName": "ZeroEmissionVehicle",
    "Type": "Boolean",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ZeroEmissionVehicleType",
      ":boolean"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ZeroEmissionVehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ZeroEmissionVehicleType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ZeroEmissionVehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "http://www.w3.org/2001/XMLSchema",
                "Name": "boolean",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "270",
    "Component": "Vehicle",
    "Comment": "P270 - bool\r\n\r\n",
    "ElementName": "VocationalVehicle",
    "Type": "Boolean",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:VocationalVehicleType",
      ":boolean"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VocationalVehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VocationalVehicleType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VocationalVehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "http://www.w3.org/2001/XMLSchema",
                "Name": "boolean",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "275",
    "Component": "Vehicle",
    "Comment": "P275 - enum\r\n\r\n",
    "ElementName": "NgTankSystem",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:NgTankSystemType",
      "v2.1:NgTankSystemType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- Compressed",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Liquefied",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "NgTankSystem",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "NgTankSystemType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "NgTankSystem",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "NgTankSystemType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "276",
    "Component": "Vehicle",
    "Comment": "P276 - bool\r\n\r\n",
    "ElementName": "SleeperCab",
    "Type": "Boolean",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:SleeperCabType",
      ":boolean"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "SleeperCab",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "SleeperCabType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "SleeperCab",
            "SchemaTypeNames": [
              {
                "Namespace": "http://www.w3.org/2001/XMLSchema",
                "Name": "boolean",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.2.1",
                "Name": "ExemptedVehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "SleeperCab",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "SleeperCabType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "271",
    "Component": "Vehicle/ADAS",
    "Comment": "P271 - bool\r\n\r\n",
    "ElementName": "EngineStopStart",
    "Type": "Boolean",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineStopStartType",
      "v2.1:EngineStopStartType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADAS",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ADASType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "EngineStopStart",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineStopStartType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADAS",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "AdvancedDriverAssistantSystemsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "EngineStopStart",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineStopStartType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "272",
    "Component": "Vehicle/ADAS",
    "Comment": "P272 - bool\r\n\r\n",
    "ElementName": "EcoRollWithoutEngineStop",
    "Type": "Boolean",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EcoRollWithoutEngineStopType",
      "v2.1:EcoRollWithoutEngineStopType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADAS",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ADASType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "EcoRollWithoutEngineStop",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EcoRollWithoutEngineStopType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADAS",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "AdvancedDriverAssistantSystemsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "EcoRollWithoutEngineStop",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EcoRollWithoutEngineStopType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "273",
    "Component": "Vehicle/ADAS",
    "Comment": "P273 - bool\r\n\r\n",
    "ElementName": "EcoRollWithEngineStop",
    "Type": "Boolean",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EcoRollWithEngineStopType",
      "v2.1:EcoRollWithEngineStopType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADAS",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ADASType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "EcoRollWithEngineStop",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EcoRollWithEngineStopType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADAS",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "AdvancedDriverAssistantSystemsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "EcoRollWithEngineStop",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EcoRollWithEngineStopType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "274",
    "Component": "Vehicle/ADAS",
    "Comment": "P274 - enum\r\n\r\n",
    "ElementName": "PredictiveCruiseControl",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v2.1:PredictiveCruiseControlType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADAS",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ADASType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PredictiveCruiseControl",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADAS",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "AdvancedDriverAssistantSystemsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "PredictiveCruiseControl",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "PredictiveCruiseControlType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "196",
    "Component": "Vehicle/TorqueLimits",
    "Comment": "P196 - [-]\r\n\r\n",
    "ElementName": "gear",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxGearNumberType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueLimits",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLimitsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLimitsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueLimits",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLimitsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLimitsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "197",
    "Component": "Vehicle/TorqueLimits",
    "Comment": "P197 - [Nm]\r\n\r\n",
    "ElementName": "maxTorque",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:TorqueLimitEntryMaxTorqueType",
      "v2.0:TorqueLimitEntryMaxTorqueType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueLimits",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLimitsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLimitsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLimitEntryMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueLimits",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLimitsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLimitsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLimitEntryMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "200",
    "Component": "Engine",
    "Comment": "P200\r\n\r\n",
    "ElementName": "Manufacturer",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ManufacturerType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "201",
    "Component": "Engine",
    "Comment": "P201\r\n\r\n",
    "ElementName": "Model",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ModelType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "261",
    "Component": "Engine",
    "Comment": "P261\r\n\r\n",
    "ElementName": "CertificationNumber",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:CertificationNumberType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "203",
    "Component": "Engine",
    "Comment": "P203\r\n\r\n",
    "ElementName": "Date",
    "Type": "DateTime",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:DateTimeWithTimezone"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 2017-01-01T00:00:00Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Pattern: .+T.+Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "204",
    "Component": "Engine",
    "Comment": "P204\r\n\r\n",
    "ElementName": "AppVersion",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AppVersionType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Min Length:5",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "061",
    "Component": "Engine",
    "Comment": "P061 - [cm³]\r\n\r\n",
    "ElementName": "Displacement",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineDisplacementType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Displacement",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDisplacementType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Displacement",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDisplacementType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Displacement",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDisplacementType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Displacement",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDisplacementType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Displacement",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDisplacementType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "063",
    "Component": "Engine",
    "Comment": "P063 - [1/min]\r\n\r\n",
    "ElementName": "IdlingSpeed",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineDeclaredSpeedType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "IdlingSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "249",
    "Component": "Engine",
    "Comment": "P249 - [1/min]\r\n\r\n",
    "ElementName": "RatedSpeed",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineDeclaredSpeedType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDeclaredSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "250",
    "Component": "Engine",
    "Comment": "P250 - [W]\r\n\r\n",
    "ElementName": "RatedPower",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineRatedPower"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedPower",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineRatedPower",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedPower",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineRatedPower",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedPower",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineRatedPower",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedPower",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineRatedPower",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "RatedPower",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineRatedPower",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "259",
    "Component": "Engine",
    "Comment": "P259 - [Nm]\r\n\r\n",
    "ElementName": "MaxEngineTorque",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineMaxTorque"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MaxEngineTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineMaxTorque",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MaxEngineTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineMaxTorque",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MaxEngineTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineMaxTorque",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MaxEngineTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineMaxTorque",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MaxEngineTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineMaxTorque",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "109",
    "Component": "Engine",
    "Comment": "P109 - [-]\r\n\r\n",
    "ElementName": "WHTCUrban",
    "Type": "Double4",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineWHTCType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 1.0000",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCUrban",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCUrban",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCUrban",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCUrban",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCUrban",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCUrban",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCUrban",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCUrban",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "110",
    "Component": "Engine",
    "Comment": "P110 - [-]\r\n\r\n",
    "ElementName": "WHTCRural",
    "Type": "Double4",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineWHTCType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 1.0000",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCRural",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCRural",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCRural",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCRural",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCRural",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCRural",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCRural",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCRural",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "111",
    "Component": "Engine",
    "Comment": "P111 - [-]\r\n\r\n",
    "ElementName": "WHTCMotorway",
    "Type": "Double4",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineWHTCType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 1.0000",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCMotorway",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCMotorway",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCMotorway",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCMotorway",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCMotorway",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCMotorway",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCMotorway",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "WHTCMotorway",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineWHTCType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "159",
    "Component": "Engine",
    "Comment": "P159 - [-]\r\n\r\n",
    "ElementName": "BFColdHot",
    "Type": "Double4",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineColdHotBalancingFactorType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 1.0000",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "BFColdHot",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineColdHotBalancingFactorType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "BFColdHot",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineColdHotBalancingFactorType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "BFColdHot",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineColdHotBalancingFactorType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "BFColdHot",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineColdHotBalancingFactorType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "BFColdHot",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineColdHotBalancingFactorType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "BFColdHot",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineColdHotBalancingFactorType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "BFColdHot",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineColdHotBalancingFactorType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "BFColdHot",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineColdHotBalancingFactorType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "192",
    "Component": "Engine",
    "Comment": "P192 [-]\r\n\r\n",
    "ElementName": "CFRegPer",
    "Type": "Double4",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineCFRegPerType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 1.0000",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFRegPer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineCFRegPerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFRegPer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineCFRegPerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFRegPer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineCFRegPerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFRegPer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineCFRegPerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFRegPer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineCFRegPerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFRegPer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineCFRegPerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFRegPer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineCFRegPerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFRegPer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineCFRegPerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "260",
    "Component": "Engine",
    "Comment": "P260 - [-]\r\n\r\n",
    "ElementName": "CFNCV",
    "Type": "Double4",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineNCVCFType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFNCV",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineNCVCFType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFNCV",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineNCVCFType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFNCV",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineNCVCFType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFNCV",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineNCVCFType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFNCV",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineNCVCFType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFNCV",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineNCVCFType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFNCV",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineNCVCFType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CFNCV",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineNCVCFType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "193",
    "Component": "Engine",
    "Comment": "P193 [enum]\r\n\r\n",
    "ElementName": "FuelType",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:FuelTypeType",
      "v2.1:FuelTypeType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- Diesel CI",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Ethanol CI",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Petrol PI",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Ethanol PI",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- LPG",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- NG",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- LPG PI",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- NG PI",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- NG CI",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelTypeType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "FuelTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelTypeType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "FuelTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelTypeType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "FuelTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "072",
    "Component": "Engine/FC-map",
    "Comment": "P072 - [1/min]\r\n\r\n",
    "ElementName": "engineSpeed",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineSpeedType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "073",
    "Component": "Engine/FC-map",
    "Comment": "P073 - [Nm]\r\n\r\n",
    "ElementName": "torque",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineFuelConsumptionMapTorqueType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "074",
    "Component": "Engine/FC-map",
    "Comment": "P074 - [g/h]\r\n\r\n",
    "ElementName": "fuelConsumption",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineFuelConsumptionMapFuelConsumptionType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "fuelConsumption",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapFuelConsumptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "fuelConsumption",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapFuelConsumptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "fuelConsumption",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapFuelConsumptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "fuelConsumption",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapFuelConsumptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "fuelConsumption",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapFuelConsumptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "fuelConsumption",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapFuelConsumptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "fuelConsumption",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapFuelConsumptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Fuel",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FuelConsumptionMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "FuelConsumptionEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "fuelConsumption",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFuelConsumptionMapFuelConsumptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "068",
    "Component": "Engine/FLD",
    "Comment": "P068 - [1/min]\r\n\r\n",
    "ElementName": "engineSpeed",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineSpeedType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "engineSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "069",
    "Component": "Engine/FLD",
    "Comment": "P069 - [N]\r\n\r\n",
    "ElementName": "maxTorque",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineFLDMaxTorqueType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "maxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "070",
    "Component": "Engine/FLD",
    "Comment": "P070 - [N]\r\n\r\n",
    "ElementName": "dragTorque",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:EngineFLDDragTorqueType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "<= 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "dragTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDDragTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "dragTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDDragTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "dragTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDDragTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "dragTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDDragTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "dragTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDDragTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "dragTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDDragTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "dragTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDDragTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Engine",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "EngineComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Mode",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "EngineFuelModeType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "FullLoadAndDragCurve",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "FullLoadAndDragCurveEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "dragTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "EngineFLDDragTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "205",
    "Component": "Gearbox",
    "Comment": "P205\r\n\r\n",
    "ElementName": "Manufacturer",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ManufacturerType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "206",
    "Component": "Gearbox",
    "Comment": "P206\r\n\r\n",
    "ElementName": "Model",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ModelType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "262",
    "Component": "Gearbox",
    "Comment": "P262\r\n\r\n",
    "ElementName": "CertificationNumber",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:CertificationNumberType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "208",
    "Component": "Gearbox",
    "Comment": "P208\r\n\r\n",
    "ElementName": "Date",
    "Type": "DateTime",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:DateTimeWithTimezone"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 2017-01-01T00:00:00Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Pattern: .+T.+Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "209",
    "Component": "Gearbox",
    "Comment": "P209\r\n\r\n",
    "ElementName": "AppVersion",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AppVersionType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Min Length:5",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "076",
    "Component": "Gearbox",
    "Comment": "P076 - [-]\r\n\r\n",
    "ElementName": "TransmissionType",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxTransmissionTypeType",
      "v2.3:GearboxTransmissionTypeType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- SMT",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- AMT",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- APT-S",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- APT-P",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TransmissionType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxTransmissionTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TransmissionType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxTransmissionTypeType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxTransmissionTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TransmissionType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxTransmissionTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TransmissionType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxTransmissionTypeType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxTransmissionTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TransmissionType",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxTransmissionTypeType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxTransmissionTypeType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "254",
    "Component": "Gearbox",
    "Comment": "P254 - [-]\r\n\r\n",
    "ElementName": "MainCertificationMethod",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxCertificationOptionType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- Option 1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Option 2",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Option 3",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Standard values",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MainCertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MainCertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MainCertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MainCertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "MainCertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "199",
    "Component": "Gearbox/Gear",
    "Comment": "P199 - [-]\r\n\r\n",
    "ElementName": "number",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxGearNumberType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "number",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "number",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "number",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "number",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "number",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "078",
    "Component": "Gearbox/Gear",
    "Comment": "P078 - [-]\r\n\r\n",
    "ElementName": "Ratio",
    "Type": "Double3",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxGearRatioType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0.000",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "157",
    "Component": "Gearbox/Gear",
    "Comment": "P157 - [Nm]\r\n\r\n",
    "ElementName": "MaxTorque",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxGearMaxTorqueType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "194",
    "Component": "Gearbox/Gear",
    "Comment": "P194 - [1/min]\r\n\r\n",
    "ElementName": "MaxSpeed",
    "Type": "Int",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxGearMaxSpeedType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "MaxSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearMaxSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "096",
    "Component": "Gearbox/Gear/Lossmap",
    "Comment": "P096 - [1/min]\r\n\r\n",
    "ElementName": "inputSpeed",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxGearInputSpeedType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "097",
    "Component": "Gearbox/Gear/Lossmap",
    "Comment": "P097 - [Nm]\r\n\r\n",
    "ElementName": "inputTorque",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxGearInputTorqueType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "098",
    "Component": "Gearbox/Gear/Lossmap",
    "Comment": "P098 - [Nm]\r\n\r\n",
    "ElementName": "torqueLoss",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:GearboxGearTorqueLossType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "GearboxFWDDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gears",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearsDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gear",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "GearDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxGearTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "210",
    "Component": "Torqueconverter",
    "Comment": "P210\r\n\r\n",
    "ElementName": "Manufacturer",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ManufacturerType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "211",
    "Component": "Torqueconverter",
    "Comment": "P211\r\n\r\n",
    "ElementName": "Model",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ModelType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "263",
    "Component": "Torqueconverter",
    "Comment": "P263\r\n\r\n",
    "ElementName": "CertificationNumber",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:CertificationNumberType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "213",
    "Component": "Torqueconverter",
    "Comment": "P213\r\n\r\n",
    "ElementName": "Date",
    "Type": "DateTime",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:DateTimeWithTimezone"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 2017-01-01T00:00:00Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Pattern: .+T.+Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "214",
    "Component": "Torqueconverter",
    "Comment": "P214\r\n\r\n",
    "ElementName": "AppVersion",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AppVersionType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Min Length:5",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "257",
    "Component": "Torqueconverter",
    "Comment": "P257 - [-]\r\n\r\n",
    "ElementName": "CertificationMethod",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:TorqueConverterCertificationOptionType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- Measured",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Standard values",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "099",
    "Component": "Torqueconverter/Characteristics",
    "Comment": "P099 - [-]\r\n\r\n",
    "ElementName": "speedRatio",
    "Type": "Double4",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:TorqueConverterSpeedRatioType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 0.0000",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "speedRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterSpeedRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "speedRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterSpeedRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "speedRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterSpeedRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "speedRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterSpeedRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "speedRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterSpeedRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "speedRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterSpeedRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "100",
    "Component": "Torqueconverter/Characteristics",
    "Comment": "P100 - [-]\r\n\r\n",
    "ElementName": "torqueRatio",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:TorqueConverterTorqueRatioType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterTorqueRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterTorqueRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterTorqueRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterTorqueRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterTorqueRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueRatio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterTorqueRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "101",
    "Component": "Torqueconverter/Characteristics",
    "Comment": "P101 - [-]\r\n\r\n",
    "ElementName": "inputTorqueRef",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:TorqueConverterInputTorqueRefType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorqueRef",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterInputTorqueRefType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorqueRef",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterInputTorqueRefType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Gearbox",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "GearboxComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorqueRef",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterInputTorqueRefType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorqueRef",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterInputTorqueRefType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorqueRef",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterInputTorqueRefType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueConverter",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "TorqueConverterDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Characteristics",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterCharacteristicsEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorqueRef",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "TorqueConverterInputTorqueRefType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "220",
    "Component": "Angledrive",
    "Comment": "P220\r\n\r\n",
    "ElementName": "Manufacturer",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ManufacturerType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Manufacturer",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ManufacturerType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "221",
    "Component": "Angledrive",
    "Comment": "P221\r\n\r\n",
    "ElementName": "Model",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:ModelType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Min Length:1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Whitespace: collapse",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Model",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "ModelType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "265",
    "Component": "Angledrive",
    "Comment": "P265\r\n\r\n",
    "ElementName": "CertificationNumber",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:CertificationNumberType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationNumber",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "CertificationNumberType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "223",
    "Component": "Angledrive",
    "Comment": "P223\r\n\r\n",
    "ElementName": "Date",
    "Type": "DateTime",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:DateTimeWithTimezone"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 2017-01-01T00:00:00Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "Pattern: .+T.+Z",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Date",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "DateTimeWithTimezone",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "224",
    "Component": "Angledrive",
    "Comment": "P224\r\n\r\n",
    "ElementName": "AppVersion",
    "Type": "Token",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AppVersionType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "Min Length:5",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "AppVersion",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AppVersionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "176",
    "Component": "Angledrive",
    "Comment": "P176 - [-]\r\n\r\n",
    "ElementName": "Ratio",
    "Type": "Double3",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AngledriveRatioType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "> 0.000",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Ratio",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveRatioType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "258",
    "Component": "Angledrive",
    "Comment": "P258 - [-]\r\n\r\n",
    "ElementName": "CertificationMethod",
    "Type": "String",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AngledriveCertificationOptionType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": "-- Option 1",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Option 2",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Option 3",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      },
      {
        "RestrictionDescription": "-- Standard values",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "CertificationMethod",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveCertificationOptionType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "173",
    "Component": "Angledrive/Lossmap",
    "Comment": "P173 - [1/min]\r\n\r\n",
    "ElementName": "inputSpeed",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AngledriveInputSpeedType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputSpeed",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputSpeedType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "174",
    "Component": "Angledrive/Lossmap",
    "Comment": "P174 - [Nm]\r\n\r\n",
    "ElementName": "inputTorque",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AngledriveInputTorqueType"
    ],
    "Restrictions": [],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "inputTorque",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveInputTorqueType",
                "IsEmpty": false
              }
            ]
          }
        ]
      }
    ]
  },
  {
    "ParamIdString": "175",
    "Component": "Angledrive/Lossmap",
    "Comment": "P175 - [Nm]\r\n\r\n",
    "ElementName": "torqueLoss",
    "Type": "Double2",
    "Mode": 1,
    "XmlTypesWithVersion": [
      "v1.0:AngledriveTorqueLossType"
    ],
    "Restrictions": [
      {
        "RestrictionDescription": ">= 0.00",
        "Versions": [
          "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0"
        ]
      }
    ],
    "XmlPaths": [
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VectoDeclarationJobType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Vehicle",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.1",
                "Name": "VehicleDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Components",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "VehicleComponentsType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": true,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v1.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.0",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Angledrive",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveDataDeclarationType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Entry",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              },
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.0",
                "Name": "AngledriveLossMapEntryType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": true,
            "IsOptional": false,
            "ElementName": "torqueLoss",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v1.0",
                "Name": "AngledriveTorqueLossType",
                "IsEmpty": false
              }
            ]
          }
        ]
      },
      {
        "Mode": "DeclarationMode",
        "PathElements": [
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "VectoInputDeclaration",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationComponent:v2.1",
                "Name": "VectoInputDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "ADC",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCComponentDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "Data",
            "SchemaTypeNames": [
              {
                "Namespace": "urn:tugraz:ivt:VectoAPI:DeclarationDefinitions:v2.3",
                "Name": "ADCDataDeclarationType",
                "IsEmpty": false
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
            "ElementName": "TorqueLossMap",
            "SchemaTypeNames": [
              {
                "Namespace": "",
                "Name": "",
                "IsEmpty": true
              }
            ]
          },
          {
            "IsAttribute": false,
            "IsOptional": false,
         